/*:
 * @plugindesc 回想モード中にコモンイベント内の変数代入と加算を無視するプラグイン
 * @help このプラグインは、回想モードからコモンイベントが呼び出された場合、コモンイベント内の変数代入と加算の操作を無視します。
 */

(function() {
    // 回想モード中であるかを示すフラグ
    var isRecollectionMode = false;

    // コモンイベントの予約コマンドをオーバーライド
    var _Game_Interpreter_command117 = Game_Interpreter.prototype.command117;
    Game_Interpreter.prototype.command117 = function(params) {
        if (Scene_Recollection._rngd_recollection_doing) {
            isRecollectionMode = true;
        }
        return _Game_Interpreter_command117.call(this, params);
    };

    // 変数の操作（代入）コマンドをオーバーライド
    var _Game_Interpreter_command122 = Game_Interpreter.prototype.command122;
    Game_Interpreter.prototype.command122 = function(params) {
        if (isRecollectionMode) {
            return true; // 変数の操作をスキップ
        }
        return _Game_Interpreter_command122.call(this, params);
    };

    // 変数の操作（加算）コマンドをオーバーライド
    var _Game_Interpreter_command123 = Game_Interpreter.prototype.command123;
    Game_Interpreter.prototype.command123 = function(params) {
        if (isRecollectionMode) {
            return true; // 変数の操作をスキップ
        }
        return _Game_Interpreter_command123.call(this, params);
    };

    // コモンイベント処理後に回想モードフラグをリセット
    var _Game_Interpreter_terminate = Game_Interpreter.prototype.terminate;
    Game_Interpreter.prototype.terminate = function() {
        if (isRecollectionMode) {
            isRecollectionMode = false;
        }
        _Game_Interpreter_terminate.call(this);
    };

    // コモンイベントの予約をクリアする際にもフラグをリセット
    var _Game_Temp_clearCommonEvent = Game_Temp.prototype.clearCommonEvent;
    Game_Temp.prototype.clearCommonEvent = function() {
        if (isRecollectionMode) {
            isRecollectionMode = false;
        }
        _Game_Temp_clearCommonEvent.call(this);
    };
})();
